/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.mods.thanos;

import club.sk1er.mods.thanos.ThanosMod;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.lwjgl.opengl.GL11;

public class DustBox {
    private static int GL_LIST_ID = -1;
    private float particleRed;
    private float particleBlue;
    private float particleGreen;
    private float particleAlpha;
    private float initParticleRed;
    private float initParticleBlue;
    private float initParticleGreen;
    private float initParticleAlpha;
    private double posX;
    private double posY;
    private double posZ;
    private double prevPosX;
    private double prevPosY;
    private double prevPosZ;
    private double initialPosX;
    private double initialPosY;
    private double initialPosZ;
    private double origPosX;
    private double origPosY;
    private double origPosZ;
    private int age;
    private double randomValOne = Math.random();
    private double randomValTwo = Math.random();
    private double randomValueThree = Math.random();
    private float targetColorBrightness = 0.0f;
    private float seed = 0.0f;
    private int layer;

    public DustBox(float particleRed, float particleGreen, float particleBlue, float particleAlpha, double posX, double posY, double posZ, double origPosX, double origPosY, double origPosZ, float seed, int layer) {
        this.particleRed = particleRed;
        this.particleBlue = particleBlue;
        this.particleGreen = particleGreen;
        this.particleAlpha = particleAlpha;
        this.initParticleRed = particleRed;
        this.initParticleBlue = particleBlue;
        this.initParticleGreen = particleGreen;
        this.initParticleAlpha = particleAlpha;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.initialPosX = posX;
        this.initialPosY = posY;
        this.initialPosZ = posZ;
        this.origPosX = origPosX;
        this.origPosY = origPosY;
        this.origPosZ = origPosZ;
        this.seed = seed;
        this.layer = layer;
        this.targetColorBrightness = (particleRed + particleBlue + particleGreen) / 5.0f;
    }

    public boolean onUpdate() {
        ++this.age;
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        int wait = 20;
        if (this.age < wait) {
            return false;
        }
        float duration = 15.0f;
        double state = 0.0;
        double percent = (float)(this.age - wait) / (duration * 20.0f);
        ThanosMod instance = ThanosMod.instance;
        int mode = instance.MODE;
        double a = percent * instance.speed - 0.2 + this.origPosY / 48.0;
        if (mode != 3) {
            a += this.origPosZ / 40.0 + this.origPosX / 40.0;
        }
        if ((state = -Math.cos(Math.toRadians(a * 180.0)) / 25.0) <= 0.0) {
            return false;
        }
        state *= 160.0;
        if (mode == 0) {
            if (state > 3.0) {
                double wiggleFactor = 50.0 / state;
                this.posX += Math.random() * (this.randomValOne - 0.5) / wiggleFactor;
                this.posY += Math.random() * (this.randomValTwo - 0.5) / wiggleFactor;
                this.posZ += Math.random() * (this.randomValueThree - 0.5) / wiggleFactor;
            }
        } else if (mode == 1) {
            double period = 2.0 * Math.pow(state, 1.0);
            this.posX = this.initialPosX + Math.cos(period) / 3.0 + Math.random() / 100.0;
            this.posY += 0.02 + Math.random() / 100.0;
            this.posZ = this.initialPosZ + Math.sin(period) / 3.0 + Math.random() / 100.0;
        } else if (mode == 2) {
            double xMult = 1.0;
            double zMult = 1.0;
            if ((double)this.seed > 0.5 && (double)this.seed < 0.75) {
                zMult = -1.0;
            }
            if ((double)this.seed < 0.5 && (double)this.seed > 0.25) {
                xMult = -1.0;
            }
            if ((double)this.seed > 0.75) {
                zMult = -1.0;
                xMult = -1.0;
            }
            this.posX += Math.random() / 200.0 * state * state * xMult;
            this.posY += Math.random() / 200.0 * state * state;
            this.posZ += Math.random() / 200.0 * state * state * zMult;
        } else if (mode == 3) {
            double mag = 0.0;
            mag = state < 1.0 ? -state : Math.pow(state - 1.0, 2.0) / 2.0 - 1.0;
            double scale = 0.0311f;
            this.posX = this.initialPosX + this.origPosX * mag * scale;
            this.posZ = this.initialPosZ + this.origPosZ * mag * scale;
        }
        boolean thresholdOne = false;
        double thresholdTwo = 5.0;
        if (state > (double)thresholdOne) {
            if (state < 4.0) {
                this.particleRed = (float)((double)this.initParticleRed + (double)(this.targetColorBrightness - this.initParticleRed) * (state / 4.0));
                this.particleGreen = (float)((double)this.initParticleGreen + (double)(this.targetColorBrightness - this.initParticleGreen) * (state / 4.0));
                this.particleBlue = (float)((double)this.initParticleBlue + (double)(this.targetColorBrightness - this.initParticleBlue) * (state / 4.0));
            } else {
                this.particleRed = this.targetColorBrightness;
                this.particleBlue = this.targetColorBrightness;
                this.particleGreen = this.targetColorBrightness;
            }
            this.particleAlpha = state < thresholdTwo ? (float)Math.max((double)this.initParticleAlpha * (1.0 / state), 0.7) : (float)Math.min(0.2, (double)(this.initParticleAlpha + (float)(0.0 - (double)this.initParticleAlpha * (state - thresholdTwo))));
        } else {
            this.particleRed = this.initParticleRed;
            this.particleGreen = this.initParticleGreen;
            this.particleBlue = this.initParticleBlue;
            this.particleAlpha = this.initParticleAlpha;
        }
        if (!instance.blending && state > 4.0 && Math.random() > 0.95) {
            return true;
        }
        return state > 6.0;
    }

    public void render(float partialTicks) {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        double f5 = (double)((float)(this.prevPosX + (this.posX - this.prevPosX) * (double)partialTicks)) - renderManager.field_78725_b;
        double f6 = (double)((float)(this.prevPosY + (this.posY - this.prevPosY) * (double)partialTicks)) - renderManager.field_78726_c;
        double f7 = (double)((float)(this.prevPosZ + (this.posZ - this.prevPosZ) * (double)partialTicks)) - renderManager.field_78723_d;
        BlockPos blockPos = new BlockPos(f5 + renderManager.field_78730_l, f6 + renderManager.field_78731_m, f7 + renderManager.field_78728_n);
        Vec3i to = new Vec3i(renderManager.field_78730_l, renderManager.field_78731_m, renderManager.field_78728_n);
        double v = blockPos.func_177951_i(to);
        if (v > (double)(ThanosMod.instance.RENDER_DISTANCE * ThanosMod.instance.RENDER_DISTANCE)) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)this.particleRed, (float)this.particleGreen, (float)this.particleBlue, (float)this.particleAlpha);
        GlStateManager.func_179137_b((double)f5, (double)f6, (double)f7);
        double scale = 0.0311f;
        GlStateManager.func_179139_a((double)(scale *= 1.0 + (double)this.layer / 4.0), (double)scale, (double)scale);
        if (GL_LIST_ID != -1) {
            GlStateManager.func_179148_o((int)GL_LIST_ID);
            GlStateManager.func_179121_F();
            return;
        }
        GL_LIST_ID = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)GL_LIST_ID, (int)4865);
        GL11.glBegin((int)5);
        GL11.glVertex3d((double)-1.0, (double)1.0, (double)1.0);
        GL11.glVertex3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glVertex3d((double)-1.0, (double)-1.0, (double)1.0);
        GL11.glVertex3d((double)1.0, (double)-1.0, (double)1.0);
        GL11.glVertex3d((double)1.0, (double)-1.0, (double)-1.0);
        GL11.glVertex3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glVertex3d((double)1.0, (double)1.0, (double)-1.0);
        GL11.glVertex3d((double)-1.0, (double)1.0, (double)1.0);
        GL11.glVertex3d((double)-1.0, (double)1.0, (double)-1.0);
        GL11.glVertex3d((double)-1.0, (double)-1.0, (double)1.0);
        GL11.glVertex3d((double)-1.0, (double)-1.0, (double)-1.0);
        GL11.glVertex3d((double)1.0, (double)-1.0, (double)-1.0);
        GL11.glVertex3d((double)-1.0, (double)1.0, (double)-1.0);
        GL11.glVertex3d((double)1.0, (double)1.0, (double)-1.0);
        GL11.glEnd();
        GL11.glEndList();
        GlStateManager.func_179121_F();
    }
}

